/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlNonAmbientLight - Contains functionality common to non-ambient lights.
//
//	.SECTION Description
//
//		This virtual class encapsulates all methods that are common
//		to non-ambient lights such as point, directional, spot, linear,
//		and area lights.  All non-ambient lights have variable
//		intensity and decay and all have a 'shadows' flag.
//
//		To create a non-ambient light, the user must instantiate and
//		call the create method on a specific type of light (as listed
//		above).  For more information on lights in general, see the
//		Class Description of the AlLight object.
//


#ifndef _AlNonAmbientLight
#define _AlNonAmbientLight

#include <AlLight.h>

class STUDIOAPI_DECL AlNonAmbientLight: public AlLight{

public:
	virtual				~AlNonAmbientLight();
	virtual AlObject*	copyWrapper() const = 0;

	AlObjectType		type() const;

	double				intensity() const;
	int					decay() const;
	API_BOOLEAN				shadows() const;

	statusCode			setIntensity( double );
	statusCode			setDecay( int );
	statusCode			setShadows( API_BOOLEAN );

protected:

	// This class is a pure virtual class.  It cannot
	// be instantiated.
						AlNonAmbientLight();
private:
};
#endif
