/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlMotionAction - Basic interface to derived class of actions for motion path actions.
//
//	.SECTION Description
//		An AlMotionAction is derived from an AlAction.  This particular
//	kind of action uses an AlCurve (a 3-D NURBS curve) to evaluate itself
//	at different times.  The AlMotionAction is defined over the range of
//	0 to 100 (the pre- and post-extrapolation types of the action apply
//	to the evaluation of times before 0 and after 100).  An AlMotionAction is
//	evaluated by interpreting the "time" between 0 and 100
//	as a percentage arc length along the AlCurve used by this action.
//	This results in an (x, y, z) point on the curve from which one of the
//	components is extracted into a double value using an "extract" component.
//
//	When this action is used in a channel, the channel will also supply
//	an "extract" component (kX_COMPONENT, kY_COMPONENT or kZ_COMPONENT)
//	to determine which of the (x, y, z) values to use as the final evaluation
//	of the action.
//
//		In order to create an AlMotionAction, you must have a valid AlCurveNode
//	with an AlCurve below it.  If you delete
//	the AlMotionAction, the AlCurveNode will not be deleted.  However, if
//	you delete the AlCurveNode (or the AlCurve below the curve node), this
//	will delete the AlMotionAction that uses that AlCurveNode.
//

#ifndef _AlMotionAction
#define _AlMotionAction

#include <AlAction.h>

class AlCurveNode;

class STUDIOAPI_DECL AlMotionAction : public AlAction {
	friend 					class AlFriend;
public:
							AlMotionAction();
	virtual					~AlMotionAction();
	virtual AlObject*		copyWrapper() const;

	statusCode				create(AlCurveNode *);

	virtual AlObjectType	type() const;

	AlCurveNode*			motionCurve() const;

protected:
	virtual AlAction*		constructAction( Aa_Action* ) const;

private:
};

#endif	// _AlMotionAction
