/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

/*
 *	This file contains enumeration types that are used by the modeling
 *	class methods.
 *
 *	This file MUST be compilable under C as well as C++ for the
 *	C interface.  If you add to this file, please make sure C-style
 *	comments are used.
 */

#ifndef _AlModel
#define _AlModel

#ifndef _curveFormType_defined
#define _curveFormType_defined

/*
 * Curve form types
 */
typedef enum  {
	kClosed,
	kOpen,
	kPeriodic,
	kInvalidCurve
} curveFormType;

#endif

#ifndef _AlClusterRestrict_defined
#define _AlClusterRestrict_defined

/*
 * Cluster restriction types
 */
typedef enum {
	kMultiCluster,
	kExclusiveCluster
} AlClusterRestrict;

#endif

#ifndef _AlOutputType_defined
#define _AlOutputType_defined

/*
 * Output types for AlPrintf
 * Warning: do not logically OR these together
 */
typedef enum {
	kStdout,
	kStderr,
	kPrompt,
	kErrlog,
	kPromptNoHistory
} AlOutputType;

/*
 * Output type mask - these are combined using 'OR's
 *
 */

typedef enum {
	oStdout			=	1U << 0,	/* note: 1U not 1 */
	oStderr			=	1U << 1,
	oPrompt			=	1U << 2,
	oErrlog 		=	1U << 3,
	oPromptNoHistory =	1U << 4
} AlOutputTypeMask;

#endif

#endif	/* _AlModel */
