/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//+
//	.NAME AlMinmaxLocator - Interface to Alias Min Max locators.
//
//	.SECTION Description
//		A min max locator finds and displays the minimum and maximum distance
//		between any of the two curves, curves on surface, or surfaces. This
//		class contains methods to create, query the distance and set the display
//		attributes in the Alias windows.

#ifndef __AlMinmaxLocator
#define __AlMinmaxLocator


#include <AlLocator.h>

class STUDIOAPI_DECL AlMinmaxLocator : public AlLocator{
	friend class			AlFriend;

public:

	AlMinmaxLocator();
	~AlMinmaxLocator();
	virtual AlObject *	    copyWrapper() const;
	virtual AlObjectType	    type() const;
	
	statusCode		        create(const AlCurve *, const AlCurve *);
	statusCode		        create(const AlCurve *, const AlCurveOnSurface *);
	statusCode		        create(const AlCurveOnSurface *, const AlCurveOnSurface *);
	statusCode		        create(const AlSurface *, const AlSurface *);
	statusCode		        create(const AlCurve *, const AlSurface *);
	statusCode		        create(const AlCurveOnSurface *, const AlSurface *);
	
	statusCode              setCombDisplay (API_BOOLEAN) ;
	statusCode              combDisplay (API_BOOLEAN &) const;
	
	statusCode              setCombScale (double) ;
	statusCode              combScale (double &) const;
	
	statusCode              setCombThreshold (double) ;
	statusCode              combThreshold (double &) const;
	
	statusCode              setCombDensity (double) ;
	statusCode              combDensity (double &) const;
	
	statusCode              minimumDistance (double &) const;
	statusCode              maximumDistance (double &) const;
	
	statusCode              setLeftJustifyMinDistance(API_BOOLEAN);
	statusCode              leftJustifyMinDistance(API_BOOLEAN &) const;
	statusCode              setLeftJustifyMaxDistance(API_BOOLEAN);
	statusCode              leftJustifyMaxDistance(API_BOOLEAN &) const;
	
	statusCode				attachedTo( AlObject *&, AlObject *& );
};


#endif

