/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

#ifndef ALMESHNODE_H
#define ALMESHNODE_H

//
//    .NAME AlMeshNode - A dag node that refers to a mesh's geometry.
//
//    .SECTION Description
//        AlCurveNode is the class used to access and manipulate meshes within
//        the dag. This class behaves like other dag nodes (see AlDagNode for
//        a description of the usage and purpose of dag nodes). Users access
//        the geometry of the curve via the 'mesh()' method which returns a
//        pointer to an AlMesh object.
//

#include <AlDagNode.h>

class AlPolyset;

class STUDIOAPI_DECL AlMeshNode : public AlDagNode
{
    friend                     class AlFriend;
    
public:
    virtual                 ~AlMeshNode();
    virtual AlObject        *copyWrapper() const;

    virtual AlObjectType    type() const;

    AlMesh*                 mesh() const;
    
    AlPolysetNode*          copyAsPolyset() const;
    

protected:
                            AlMeshNode();
};

#endif
