/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//	.NAME AlMeasure - Support for measurement of distances between objects
//
//	.SECTION Description
//		The following are a series of overloaded functions named
//		minDist().  These can be used to find the closest points
//		between any two surfaces, curves, and/or points.
//
//		The minDist() functions will return a negative value if and
//		only if the objects it is given do not exist.
//
//		For the sake of continuity, the order of the two objects to
//		be measured is always highest dimentionality to lowest.
//

#include <AlStyle.h>

class STUDIOAPI_DECL AlMeasure
{
public:
	static double minDist( AlSurface* surface1, AlSurface* surface2,
				  double* u1=NULL, double* v1=NULL, double P1[]=NULL,
				  double* u2=NULL, double* v2=NULL, double P2[]=NULL,
				  int interval_u=20, int interval_v=20);

	static double minDist( AlSurface* surface1, AlCurve* curve2,
				  double* u1=NULL, double* v1=NULL, double P1[]=NULL,
				  double* t2=NULL, double P2[]=NULL,
				  int interval=100);

	static double minDist( AlSurface* surface1, double P2[3],
				  double* u1=NULL, double* v1=NULL, double P1[]=NULL);

	static double minDist( AlCurve* curve1, AlCurve* curve2,
				  double* t1=NULL, double P1[]=NULL,
				  double* t2=NULL, double P2[]=NULL, int inter=100);

	static double minDist( AlCurve* curve1, double P2[3],
				  double* t1=NULL, double P1[]=NULL);
};
