/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//+
//	.NAME AlLocator - Contains functionality common to all the Alias locators
//
//	.SECTION Description
//		This virtual class encapsulates methods common to all the Alias locators,
//		such as annotationLocator, distanceLocator, angleLocator, radialLocator, 
//		deviationLocator and minmaxLocator.
//
//		This class contains methods for picking, deleting, and naming locators.
//		In addition, methods are available for working with layers and for changing
//		invisibility and templated modes.
//
//		To create a locator, the user must instantiate and call the create method
//		of a specific type of locator (eg. an angle locator ).
//
//		The annotation, distance and angle locators depend on one or more construction entities
//		point types, such as a curve point. If a construction point is deleted, their
//		dependent annotation, distance and angle locators are automatically deleted.
//		Similarly, the radial, deviation and minmax locators are dependent on other
//		objects. If those objects are deleted, the dependent radial, deviation,
//		and minmax locators are also deleted.
//
//		The locator classes are derived as follows, where a class inherits the
//		functionality defined in the class above it. The user can not instantiate
//		the locator (AlLocator) class.
//
//
// .ss 24
//	.nf
//	%@	   					            Locator
//	%@	                 					|
//	%@	  	________________________________________________________
//	%@	  	|				|		|			|		|			|
//	%@	  annotation		distance 	angle 	radial 	deviation 	minmax
//	%@
//	.fi
// .ss 12
//

#ifndef __AlLocator
#define __AlLocator

#include <AlObject.h>


class STUDIOAPI_DECL AlLocator : public AlObject{
	friend                  class AlFriend;

public:
	virtual ~AlLocator();

	virtual statusCode	    deleteObject();
	virtual AlObject *	    copyWrapper() const = 0;
	virtual AlObjectType	type() const;

	virtual const char*				name() const;
	virtual statusCode				setName( const char * );

	AlLayer *				layer();
	statusCode 				setLayer( AlLayer * );
	
	API_BOOLEAN					invisible();
	statusCode				setInvisible( API_BOOLEAN );

	statusCode              pick();
	statusCode              unpick();
	statusCode              isPicked(API_BOOLEAN &) const;
	statusCode              templated(API_BOOLEAN &) const;

protected:
	AlLocator();
private:
	static void		       initMessages();
	static void		       finiMessages();
};
#endif

