/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//	.NAME AlLiveData - Utility functions for OpenAlias
//
//	.SECTION Description
//		These functions are support functions for use with OpenAlias plugins
//

#ifndef	_al_livedata
#define _al_livedata

#include <stdarg.h>
#include <AlStyle.h>
#include <AlModel.h>

typedef enum {
	kFileBrowseRead,
	kFileBrowseWrite
} AlFileBrowseMode;

typedef enum {
	kOK_Cancel,
	kYes_No_Cancel,
	kOK_Only,
	kYes_No
} AlConfirmType;

typedef enum {
	kOK,
	kYes,
	kNo,
	kCancel
} AlAnswerType;

/* 
 * The following define is used for exporting the 
 * plugin_init and plugin_exit functions on NT. 
 */
#ifdef _WIN32
# define PLUGINAPI_DECL __declspec(dllexport)
#elif defined(AW_HIDE_SYMBOLS)
# define PLUGINAPI_DECL __attribute__ ((visibility("default")))
#else 
# define PLUGINAPI_DECL 
#endif /* _WIN32 */

extern "C"
{
/* C linkages for convience */
STUDIOAPI_DECL void AlPrintf( AlOutputType, const char*, ... );
STUDIOAPI_DECL void AlVprintf( AlOutputType, const char*, va_list ap );
STUDIOAPI_DECL const char *AlGetAliasPreference( const char * );
}

//
// C++ functions
//

class  AlList;

STUDIOAPI_DECL void AlAllowMenuRebuilds( API_BOOLEAN );
STUDIOAPI_DECL void AlRebuildMenus( void );
STUDIOAPI_DECL void AlResetAllMenus( void );
STUDIOAPI_DECL statusCode AlDebugResetOptionBox( const char *editorName );
STUDIOAPI_DECL const char *AlInvokeSchemeCommand( const char *command );
STUDIOAPI_DECL const char *AlInvokeSchemeFile( const char* fname, const char *prefix = 0 );
STUDIOAPI_DECL statusCode  AlFileBrowser(	AlFileBrowseMode, char **, const char *,
							API_BOOLEAN, const char * );
STUDIOAPI_DECL statusCode  AlFileBrowser(	AlFileBrowseMode, char **, const char *,
							API_BOOLEAN, const char *, const char * );

STUDIOAPI_DECL API_BOOLEAN AlEscapeKeyPressed( void );
STUDIOAPI_DECL statusCode AlPromptBox( AlConfirmType, const char*, AlAnswerType*, short, short );
STUDIOAPI_DECL statusCode AlConfirmBox( // API version of AliasConfirmBox
    int charsPerLine, /* 0 means no formatting */
	int	x,
	int y,
	int *answer,
	const char *dont_ask_symbolName,
	const char *notice,
	... );
STUDIOAPI_DECL statusCode AlScrollablePromptBox( AlConfirmType , const char *, char *, AlAnswerType * );
STUDIOAPI_DECL statusCode AlStringPromptBox( AlConfirmType type, const char *, AlAnswerType *,char *& );

STUDIOAPI_DECL statusCode AlGetInteger( const char *, int& );
STUDIOAPI_DECL statusCode AlGetDouble( const char *, double& );
STUDIOAPI_DECL statusCode AlGetString( const char *, const char *& );
STUDIOAPI_DECL statusCode AlSetInteger( const char *, int );
STUDIOAPI_DECL statusCode AlSetDouble( const char *, double );
STUDIOAPI_DECL statusCode AlSetString( const char *, const char* );

STUDIOAPI_DECL AlList *PluginDirPathName( void );
STUDIOAPI_DECL AlList *PluginConductorDirPathName( void );
STUDIOAPI_DECL AlList *PluginAwUserConfigDirPathName( void );
STUDIOAPI_DECL AlList *AppExchangeDirPathName( void );

STUDIOAPI_DECL void AlPrintf( unsigned int, const char*, ... );
STUDIOAPI_DECL void AlVprintf( unsigned int, const char*, va_list ap );

STUDIOAPI_DECL char *makeAltPath(const char *dirName, const char *suffix);

#endif /* _al_livedata */
