/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlList - Simple List class for AlLinkItem objects.
//
//	.SECTION Description
//		This simple container class provides the ability to create and
//		access a list of objects derived from the AlLinkItem class.
//

#ifndef _AlList
#define _AlList

#include <AlStyle.h>

class AlLinkItem;

class STUDIOAPI_DECL AlList 
{
  public:
				AlList( AlLinkItem *item = (AlLinkItem*)0 );
	virtual		~AlList();

	AlLinkItem*	first( void ) const;
	AlLinkItem*	last( void ) const;

	void		append( AlLinkItem* );
	int			remove( AlLinkItem* );
	void		clear();

  private:
	AlLinkItem*	fHead;
	AlLinkItem*	fTail;

private:
	// Disallow the copy constructor and copy assignment
	AlList (const AlList &);
	AlList &operator= (const AlList &);
};

#endif
