/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlLinearLight - Encapsulates the creation, deletion, and manipulation of linear lights.
//
//	.SECTION Description
//
//		A linear light emits light in all directions.
//		A linear light would be used, for instance, to simulate a
//		fluorescent light tube.  The length of the line is defined
//		by the light's axis.
//
//		To determine the endpoints of this light, use the worldPosition()
//		method and the endpoint() method.
//
//		Although this class inherits methods to access the 'look at'
//		and 'up' nodes of a light, they are not used.  The direction
//		and twist of an area light is changed by translating and rotating
//		the transformation of the light's position node.
//


#ifndef _AlLinearLight
#define _AlLinearLight

#include <AlDirectionLight.h>

class STUDIOAPI_DECL AlLinearLight: public AlDirectionLight
{

public:
						AlLinearLight();
	virtual				~AlLinearLight();

	virtual AlObject*   copyWrapper() const;

	statusCode			create();

	AlObjectType		type() const;

	statusCode			axis( double&, double&, double& ) const;
	statusCode			setAxis( double, double, double );

	statusCode			endpoint( double&, double&, double& ) const;

private:
	// init/fini inherited
};
#endif
