/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlLineAttributes
#define _AlLineAttributes

//+
//
//	.NAME AlLineAttributes - Interface to Alias line attributes.
//
//	.SECTION Description
//
//		AlLineAttributes is a class derived from the AlAttributes class.
//		This class allows access to the attributes for a line.
//
//		The attributes which define a line are just its start point, and
//		its end point. Coordinates are given in object space, and not
//		world space.
//

#include <AlAttributes.h>

class STUDIOAPI_DECL AlLineAttributes : public AlAttributes 
{
	friend class			AlFriend;

public:
	virtual AlObjectType			type() const;
	AlObject*						copyWrapper() const;

	statusCode				startPoint(double&, double&, double&) const;
	statusCode				endPoint(double&, double&, double&) const;

	statusCode				setStartPoint(double, double, double);
	statusCode				setEndPoint(double, double, double);

protected:
							AlLineAttributes(struct Spline_surface*);
	virtual					~AlLineAttributes();
};

#endif
