/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlLightNode - is the dag node class for lights.
//
//	.SECTION Description
//
//		This class is a dag node class used specifically for lights.
//		Each AlLight object has three light nodes for position, 'look at'
//		and 'up' points.  (For more information on how AlLight's
//		and AlLightNode's work together, see the Class Description for
//		the AlLight object.)
//
//		To create a light node, the user must create a specific type
//		of light, which automatically creates the necessary light
//		nodes.  These light nodes are grouped and inserted into
//		the universe's dag.  The user cannot directly instantiate
//		a light node.
//
//		To figure out whether or not a light node represents a position,
//		a 'look at' or an 'up' point, the user can use:
// .br
//			1) the isPositionNode(), isLookAtNode(), isUpNode() methods, or
// .br
//			2) the type() method of the attached AlLight object.
// .in
//
//		A light node can be deleted in two ways.  When a light node
//		is deleted, its associated light (and other light nodes)
//		are deleted.  Alternatively, when a light is deleted, its light
//		nodes are also deleted.
//


#ifndef _AlLightNode
#define _AlLightNode

#include <AlDagNode.h>

class AlLight;

struct Dag_node;
struct AR_LightInfo;

class STUDIOAPI_DECL AlLightNode: public AlDagNode 
{
	friend class AlFriend;

public:

	virtual				~AlLightNode();
	virtual AlObject	*copyWrapper() const;

	statusCode			deleteObject();

	AlObjectType		type() const;

	AlLight*			light() const;
	AlLight*			light(AlTM&) const;

	virtual API_BOOLEAN		isInstanceable();
	API_BOOLEAN				isLookAtNode() const;
	API_BOOLEAN				isUpNode() const;
	API_BOOLEAN				isPositionNode() const;

protected:
	// This class can only be instantiated by an AlLight object.
	//
	AlLightNode();
};
#endif
