/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
 
//
//	.NAME AlLayerShader - Base object for representing shader data
//
//	.SECTION Description
//		This class encapsulates the basic functionality for checking and
//		setting the name of a shader as well as accessing the textures that
//		a particular shader refers to, and the animation on the shader.
//		Shader objects are accessible through both the AlUniverse class and
//		the objects that reference them (AlSurface and AlFace classes).
//
//		A layered shader object may reference shaders.  The firstShader() and
//		nextShader() methods are used to access these textures.
//
//		firstShader() returns the first shader that the shader object
//		references.  nextShader() moves from a given referenced shader
//		to the next shader in order, as related to the layered shader object.
//
//

#ifndef _AlLayeredShader
#define _AlLayeredShader

#include <AlObject.h>
#include <AlAnimatable.h>
#include <AlAnim.h>
#include <AlPixFile.h>

class AlList;
class AlIterator;

class STUDIOAPI_DECL AlLayeredShader : public AlObject {
	friend class			AlFriend;
public:
							AlLayeredShader();
	virtual					~AlLayeredShader();
	virtual statusCode		deleteObject();
	virtual AlObject		*copyWrapper() const;

	statusCode				create();


	virtual AlObjectType	type() const;

	virtual const char*		name() const;
	virtual statusCode		setName( const char * );

	AlShader*				getFirstShader() const;
	AlShader*				getNextShader(const AlShader*) const;

	bool					addShader(AlShader*);
	bool					removeShader(AlShader*);

	AlLayeredShader*		copyObject();
	API_BOOLEAN				isUsed();

private:
	static void				initMessages();
	static void				finiMessages();

	API_BOOLEAN				extractType( int&, void *&, void *& ) const;
};

#endif // _AlLayeredShader
