/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlJoint
#define _AlJoint
//
//	.NAME AlJoint - Interface to joint node data.
//
//	.SECTION Description
//		The AlJoint class allows access to the joint information
//		on an AlDagNode.
//
//		See the discussion of skeletons, joints, constraints, ik, character
//		builder, ..etc.. in the Alias Studio manuals for a full description.
//
//		Briefly, the joint node is used by the inverse kinematic algorithm
//		to define properties of a joint.  The character joint attributes
//		are used to define properties of the bone below the joint for
//		skinning operations.
//
//		In general, minimum values must be less than maximum values and
//		stiffness values must be between 0 and 100 inclusive.
//

/*
// Some enumerated type used by character joint attributes
//
*/

typedef enum {
	kJointInterpLinear		= 0,
	kJointInterpExponential	= 1,
	kJointInterpSine		= 2
} AlJointInterpolationType;

typedef enum {
	kBulgeDefinition		= 0,
	kBulgeEvenlySpaced		= 1
} AlBulgeSections;

typedef enum {
	kBulgeLowerJoint		= 0,
	kBulgeOtherNode			= 1
} AlBulgeRelateTo;

#include <AlAnim.h>
#include <AlObject.h>

struct SK_joint_s;
struct Dag_node;

class AlDagNode;
class AlIterator;

class STUDIOAPI_DECL AlJoint : public AlObject
{
	friend class			AlFriend;

public:
	virtual					~AlJoint();
	virtual AlObject*		copyWrapper() const;

	virtual AlObjectType	type() const;

	AlIKHandle*             endEffectorHandle( void ) const;
	AlIKHandle*             firstRootHandle( void ) const;
	AlIKHandle*             nextRootHandle( const AlIKHandle* ) const;
	statusCode              nextRootHandleD( AlIKHandle* ) const;
	statusCode              applyIteratorToRootHandles( AlIterator*, int& );

	statusCode				useTransforms( API_BOOLEAN[3], API_BOOLEAN[3] ) const;
	statusCode				useLimits( API_BOOLEAN[3], API_BOOLEAN[3] ) const;
	statusCode				rotation( double[3], double[3], int[3] ) const;
	statusCode				translation( double[3], double[3], int[3] ) const;
	statusCode				restPose( double[3], double[3] ) const;

	statusCode				setUseTransforms( const API_BOOLEAN[3], const API_BOOLEAN[3] );
	statusCode				setUseLimits( const API_BOOLEAN[3], const API_BOOLEAN[3] );
	statusCode				setRotation( const double[3], const double[3], const int[3] );
	statusCode				setTranslation( const double[3], const double[3], const int[3] );
	statusCode				setRestPose( const double[3], const double[3] );
	statusCode				assumeRestPose( void );

	API_BOOLEAN					charJoint() const;
	statusCode				charJointLimits(double&, double&, AlJointInterpolationType&) const;
	API_BOOLEAN					useBulge() const;
	statusCode				bulgeAttributes(int*, int*, double*, AlBulgeSections*, int*, int*, AlDagNodeFields*, AlBulgeRelateTo*, char*, double*) const;

	statusCode				setCharJoint(API_BOOLEAN);
	statusCode				setCharJointLimits(double, double, AlJointInterpolationType);
	statusCode				setUseBulge(API_BOOLEAN);
	statusCode				setBulgeAttributes(int, int, double, AlBulgeSections, int, int, AlDagNodeFields, AlBulgeRelateTo, const char *, double);

	AlDagNode*				dagNode( void ) const;

protected:
							AlJoint();
	void					joint_modified( void );
private:
	static void       		initMessages();
	static void       		finiMessages();
};

#endif	/* _AlJoint */
