/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlIntersect - Support for intersection of objects
//
//	.SECTION Description
//		This collection of classes provides the programmer with the ability
//		to determine points of intersection between two curves, a curve and
//		a surface, or two surfaces.
//
//		Each type of intersection responds with its own class of results:
//		AlIntersectCurveCurveInfo, AlIntersectCurveSurfInfo, and
//		AlIntersectSurfSurfInfo.  The first two of these are simple AlList
//		classes.  The last one is a stucture storing pointers to AlCurves
//		and (x/y/z) points.
//

#ifndef _AlIntersect
#define _AlIntersect

#include <AlLinkItem.h>

class AlList;
class AlCurve;
class AlSurface;
class AlIntersectSurfSurfInfo;

class STUDIOAPI_DECL AlIntersect
{
	public:

	static statusCode	intersect( AlCurve* curve1, AlCurve* curve2,
						AlList* &cclist );
	static statusCode	intersect( AlCurve* curve, AlSurface* surface,
						AlList* &cslist );
	static statusCode	intersect( AlSurface* surface1, AlSurface* surface2,
						AlIntersectSurfSurfInfo& ss );
	static statusCode	intersect( AlSurface *surface, double point[3], double planeNormal[3], 
						AlIntersectSurfSurfInfo &ss );
	static statusCode	intersect( AlSurface *surface, double point[3], double planeNormal[3], 
						double boundingBoxTol, API_BOOLEAN &noIntersect, API_BOOLEAN &intersectWithinTol,
						double &x, double &y, double &z  );
};

class STUDIOAPI_DECL AlIntersectCurveCurveInfo : public AlLinkItem
{
	friend class					AlIntersect;

	public:
		AlIntersectCurveCurveInfo*	nextItem() const;
		AlIntersectCurveCurveInfo*	prevItem() const;

		double				tCurve1, tCurve2;
		double				point[3];

	protected:
							AlIntersectCurveCurveInfo() {};
		virtual				~AlIntersectCurveCurveInfo();
};

class STUDIOAPI_DECL AlIntersectCurveSurfInfo : public AlLinkItem
{
	friend class					AlIntersect;

	public:
		AlIntersectCurveSurfInfo*	nextItem() const;
		AlIntersectCurveSurfInfo*	prevItem() const;

		double				t;
		double				pointOnCurve[3];

		double				u,v;
		double				pointOnSurface[3];

	protected:
							AlIntersectCurveSurfInfo() {};
		virtual				~AlIntersectCurveSurfInfo();
};

typedef double double3[3];
class STUDIOAPI_DECL AlIntersectSurfSurfInfo
{
public:
	int			numberIsolatedPoints;
	double3*	isolatedPoints;

	int			numberIntersectionCurves;
	AlCurve**	intersectionCurves;

	int			numberBoundaryCurves;
	AlCurve**	boundaryCurves;

				~AlIntersectSurfSurfInfo();
};

#endif
