/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlIKHandleNode
#define _AlIKHandleNode

//
//	.NAME AlIKHandleNode - Interface to dag nodes of IK handles.
//
//	.SECTION Description
//
//		All AlIKHandles have an associated AlDagNode which define their
//		position and orientation.  This class provides an interface to
//		the AlDagNode above an AlIKHandle.
//
//		The position of this AlDagNode defines the goal position for
//		solving the inverse kinematics.
//		The rotation of this AlDagNode has a special function
//		depending on the solver type of the IK handle below.
//
//		Single-chain: the three rotational axes get mapped to a single plane
//		rotation and two pole rotations, depending on the rotation order
//		defined for this IK handle.  In particular, the first axis in
//		the handle's rotation order controls the rotation of the plane
//		passing through the root and end-effector nodes, which is used to
//		orient the single-chain solution.  The second and third axes in
//		the rotation order reorient the up vector of the IK handle.
//		The IK handle up vector defines the axis around which the
//		single-chain IK solution will flip when the end-effector crosses
//		over the line passing through the root and the end-effector.
//		The IK handle rotation order can be accessed through the
//		AlIKHandle class.
//
//		Multi-solver: if the IK handle has an orientation goal,
//		rotating the IK handle controls the orientation of the bone
//		directly above the end-effector.  A solution will be found such that
//		the local axes of the end-effector joint attempt to match the
//		local axes of the IK handle.
//

#include <AlDagNode.h>

class AlIKHandle;

class STUDIOAPI_DECL AlIKHandleNode : public AlDagNode 
{
	friend class			AlFriend;

public:
	virtual					~AlIKHandleNode();
	virtual AlObject*		copyWrapper() const;

	virtual AlObjectType	type() const;

	AlIKHandle*				IKHandle() const;
	AlIKHandle*				IKHandle(AlTM&) const;

protected:
							AlIKHandleNode();
};

#endif
