/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlHashable - Base class for objects which can be inserted into
//		an AlDictionary.
//
//	.SECTION Description
//		AlHashable provides a contract for any class which wishes to be
//		stored in an AlDictionary, namely the necessity of providing a hash
//		key and the ability to be stored in a list.
//

#ifndef _AlHashable
#define _AlHashable

#include <AlLinkItem.h>

class AlDictionary;
class AlObject;

struct hashkeydata
{
	void*		ptr1;
	void*		ptr2;
	long int	num;
};

class STUDIOAPI_DECL AlHashKey 
{
public:
						AlHashKey();
						AlHashKey( const void* );
						AlHashKey( const void *, long int );
						AlHashKey( const void *, const void * );
						AlHashKey( const void *, const void *, long int );
						// AlHashKey( long int, long int )

						AlHashKey( const AlHashKey& );
						~AlHashKey();

	AlHashKey&			operator =( const AlHashKey& );

	int					operator ==( const AlHashKey& ) const;
						operator int() const;

	void				*getPtr1( void ) const;
	void				*getPtr2( void ) const;
	long int 			getNum( void ) const;

	unsigned long int 	hash( int table_size ) const;
	void				output( void ) const;

private:
	hashkeydata			data;
	void				resetData( void );
};

class STUDIOAPI_DECL AlHashable : public AlLinkItem 
{
	friend 				class AlDictionary;
	friend 				class AlFriend;
	friend				class AlDictionaryOperators;
	friend				class AlInvalidatorIterator;

protected:
						AlHashable();
	virtual				~AlHashable();

	int					setData( void* );
	int					setData( void*, void* );
	int					setData( void*, long int );
	int					setData( void*, void*, long int);
	int					invalidate( void );

	int					setData( const AlHashKey& );

	API_BOOLEAN				isValid( void ) const;

private:
	AlHashKey			fData;
	AlDictionary		*fDict;

	AlLinkItem*			getNext( void ) const;

private:
	// Disallow the copy constructor and copy assignment
	AlHashable (const AlHashable &);
	AlHashable &operator= (const AlHashable &);
};

#endif // _AlHashable
