/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlFunctionHandle - Class for creating the OpenAlias interface to Alias
//
//	.SECTION Description
//		This class provides a means to interface the OpenAlias application
//		to the Alias user interface.  An AlFunction class or one of its
//		derivatives ( AlMomentaryFunction, AlContinuousFunction ) is
//		required by the create method.  Note that the string name of
//		an Al*Function could also be specified in the create() method.
//
//		The class AlSubmenu is used for creating submenus in Alias.  Create
//		a new submenu on an existing Alias menu and then use the 
//		AlFunctionHandle::installOnSubmenu() method to add a new item.  
//		Note: avoid attaching submenu items to submenus created by other
//		plug-ins since your submenu item will disappear when the other plug-in
//		is unloaded.
//

#ifndef _AlFunctionHandle
#define _AlFunctionHandle

#include <AlStyle.h>

class AlFunction;
class TuiChoice;
class TuiMultiChoice;

class STUDIOAPI_DECL AlFunctionHandle {
public:
						AlFunctionHandle();
						~AlFunctionHandle();

	statusCode			create( const char*, const char* );
	statusCode			create( const char*, AlFunction *func );

	AlFunctionHandle&	operator =( const AlFunctionHandle& f );
	int					operator !() const;

	statusCode			setAttributeString( const char * );
	statusCode			setOptionBox( const char *, const char *, const char *dirname = NULL );
	statusCode			setOptionBox( const char * );
	statusCode			setIconPath( const char* path );
	statusCode			setHelpFile( const char* file );

	statusCode			addToMenu( const char * );
	statusCode			appendToMenu( const char * );
	statusCode			installOnMenu( const char *, API_BOOLEAN );
	
	statusCode			installOnSubmenu( const char * );

	statusCode			addSeparator( const char * );

	statusCode			removeFromMenu();
	statusCode			deleteObject();

private:
	statusCode			attachToMenu( const char *, API_BOOLEAN );
	TuiChoice*			fChoice;
};

class STUDIOAPI_DECL AlSubmenu {
public:
						AlSubmenu();
						~AlSubmenu();

	statusCode			createSubmenu( const char *, const char * );
	statusCode			removeSubmenu( );

private:
	TuiMultiChoice*			fChoice;
};

#endif	// _AlFunctionHandle

