/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlFaceNode
#define _AlFaceNode

//+
//	.NAME AlFaceNode - Interface to the dag node that gives access to faces.
//
//	.SECTION Description
//		AlFaceNode is the class used to access faces in the dag.  Faces
//		can be created from scratch or read in from a wire file and
//		accessed via the firstFace() method.  Faces are a collection of
//		curves that all lie in the same plane.  An AlFaceNode points to
//		an AlFace, which points to the next face in the collection etc...
// .br
//		Add faces to the collection with the addFace() method and
//		remove them with the removeFace() method.  In order to access the
//		list of faces, you walk through the face list with AlFace
//		methods nextFace() and prevFace().
// .br
//		There are two ways to delete an AlFaceNode.  If the
//		AlFaceNode::deleteObject() method is called, then this node's AlFace
//		objects are all deleted.  If this node only has one face and its
//		deleteObject() method is called, then this node is deleted as well.
//


#include <AlCurveNode.h>

class AlFriend;

class STUDIOAPI_DECL  AlFaceNode : public AlCurveNode 
{
	friend	class			AlFriend;
public:
							AlFaceNode();
	virtual					~AlFaceNode();
	virtual AlObject*		copyWrapper() const;

	statusCode				create( AlFace * );

	virtual AlObjectType	type() const;

	AlFace*					firstFace() const;
	AlFace*					firstFace(AlTM&) const;

	statusCode				addFace( AlFace* );
	statusCode				removeFace( AlFace* );

	AlSurface*				convertToTrimmedSurface( API_BOOLEAN worldSpace =FALSE )const;
	statusCode				normal( double &x, double &y, double &z) const;
protected:
};

#endif
