/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlFace
#define _AlFace

//	.NAME AlFace - Interface to Alias face curves.
//
//	.SECTION Description
//		An AlFace is derived from AlCurve and inherits AlCurve's public methods.
//
//		AlFace objects are created independently from the AlFaceNode, and
//		then added to the AlFaceNode afterwards.  An AlFaceNode requires
//		one valid AlFace object in order for it to be created.  Other
//		faces can be added to the list of faces under the AlFaceNode
//		afterwards using AlFaceNode::addFace().
//
//		Deleting a face can cause one of two things to happen.  If the AlFace
//		is not under an AlFaceNode, or it is one of several faces under an
//		AlFaceNode, then only the face will be deleted.  If the AlFace is
//		the only face under the AlFaceNode, then the AlFaceNode will also
//		be deleted.
//
//		Each face curve must be planar and each face curve must lie in the same
//		plane as all the others.  In addition to the parent class (AlCurve)
//		methods this class allows you to walk through the list of the face
//		curves that make up the face.
//
//		All AlFace objects will have at least one shader attached to them.
//		These can be accessed through the firstShader and nextShader methods.
//

#include <AlCurve.h>

class AlShader;
class AlSwitchShader;
class AlLayeredShader;
class AlFriend;
class AlFaceNode;
struct AlRenderInfo;

class STUDIOAPI_DECL AlFace : public AlCurve 
{
	friend class			AlFriend;
public:

							AlFace();
	virtual					~AlFace();
	virtual statusCode		deleteObject();
	virtual AlObject*		copyWrapper() const;

	statusCode          	create( int, curveFormType, int, const double[], int, const double[][4], const int[] );

	virtual AlObjectType	type() const;

	AlFaceNode*				faceNode() const;

	AlFace*					prevFace() const;
	AlFace*					nextFace() const;

	statusCode				prevFaceD();
	statusCode				nextFaceD();

	statusCode				area( double&, API_BOOLEAN worldCoords=TRUE, double tolerance=0.001 );
	AlShader*				firstShader() const;
	AlShader*				nextShader( AlShader* ) const;
	AlSwitchShader*			getSwitchShader() const;
    AlLayeredShader*        getLayeredShader() const;
	statusCode				nextShaderD( AlShader* ) const;

	statusCode				renderInfo( AlRenderInfo& ) const;
	statusCode				setRenderInfo( const AlRenderInfo& ) const;

	statusCode				normal( double[3] ) const;
};

#endif
