/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//+
//	.NAME AlDistanceLocator - Displays the distance between two locators.
//
//	.SECTION Description
//		This locator is used to display and find the distance between any
//		two point locators (AlPointLocator). If any of the two point locators
//		on which this locator depends is deleted, this locator is automatically
//		deleted. This class contains methods to create the locator, query the
//		distance, and set the display attributes of the locator.

#ifndef __AlDistanceLocator
#define __AlDistanceLocator



#include <AlLocator.h>

class AlPoint;

class STUDIOAPI_DECL AlDistanceLocator : public AlLocator
{
	friend class			AlFriend;

public:
	AlDistanceLocator();
	~AlDistanceLocator();
	
	virtual AlObject *		copyWrapper() const;
	virtual AlObjectType	type() const;
	statusCode		   		create(const AlPoint *,
								   const AlPoint *,
								   API_BOOLEAN trueDisplay = TRUE);
								   
	AlPoint*       			startPoint() const;
	AlPoint*       			endPoint() const;
	
	statusCode             	trueDisplay(API_BOOLEAN &) const;
	statusCode             	setTrueDisplay(API_BOOLEAN);
	
	statusCode             	offset(double &) const;
	statusCode             	setOffset(double);
	
	statusCode             	distance(double &, double &, double &) const;

};


#endif


