/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//	.NAME AlDirectionLight - Encapsulates the functionality common to all directional lights.
//
//	.SECTION Description
//
//		There are two ways that this class is used.  If the user
//		instantiates and calls the create method on an AlDirectionLight,
//		the resulting object is a light that has color, intensity,
//		and direction but no obvious source in a scene.  This type
//		of direction light does not decay with distance.  Sunlight
//		is a direction light of this type.
//
//		Alternatively, the  user could instantiate and create an
//		AlSpotLight, AlLinearLight, or AlAreaLight (which are all
//		considered "directional" and which are all derived from
//		this light class).
//
//		Although all direction lights can access the
//		"look at" and "up" nodes of a light, only the spot light
//		uses these nodes.
//


#ifndef _AlDirectionLight
#define _AlDirectionLight

#include <AlNonAmbientLight.h>

class AlLightNode;

class STUDIOAPI_DECL AlDirectionLight: public AlNonAmbientLight 
{

public:
						AlDirectionLight();
	virtual				~AlDirectionLight();
	virtual AlObject*	copyWrapper() const;

	statusCode			create();

	AlObjectType		type() const;

	AlLightNode*  		lookAtNode() const;
	AlLightNode*      	upNode() const;

	virtual statusCode	direction( double&, double&, double& ) const;
	virtual statusCode	setDirection( double, double, double );

private:
	// init/fini inherited
};
#endif
