/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//-
//	.NAME AlDictionary - Class used for fast storage and retrieval of
//		AlObjects keyed on Alias data.
//
//	.SECTION Description
//		This class provides methods for storage, lookup, and deletion of
//		AlObjects.  The objects are keyed on a low-level AlHashKey value
//		which is used as a general storage mechanism for references to
//		Alias data (see AlHashable.h)
//
//	This file also contains the call AlDictionaryOperators, which should
//	hold all the different functions that operate on elements in the dictionary
//	through the applyToAll method.  The canonical example of this is
//	invalidateAll.
//+

#ifndef _AlDictionary
#define _AlDictionary

#include <AlStyle.h>

class AlHashKey;
class AlHashable;
class AlList;

#define DEFAULT_MIN_DICT_SIZE 256

class STUDIOAPI_DECL AlDictionaryIterator 
{
public:
	AlDictionaryIterator();
	virtual int			apply( AlHashable* ) = 0;

private:
	// Disallow the copy constructor and copy assignment
	AlDictionaryIterator (const AlDictionaryIterator &);
	AlDictionaryIterator &operator= (const AlDictionaryIterator &);
};

class STUDIOAPI_DECL AlDictionary 
{
	friend				class AlFriend;
	friend				class AlDictionaryOperators;
	friend				class AlHashable;
public:
						AlDictionary( int = DEFAULT_MIN_DICT_SIZE );
						~AlDictionary( void );

	int					insertAs( AlHashable*, const AlHashKey& );
	int					remove( AlHashable* , API_BOOLEAN );
	int					applyToAll( const AlHashKey&, AlDictionaryIterator* );
	int					applyToValid( AlDictionaryIterator* );
	int					applyToInvalid( AlDictionaryIterator* );

	void				collect( void );
	void				moveAll( AlDictionary* );
	int					changeSize( int newSize );

//	AlHashable*			lookup( AlHashKey& );
	statusCode			dumpHashTable( void );

private:
	AlList				*fTable;
	static AlList		*fGarbage;
	int					minSize, fSize;
	int					count;
	int					numberFloor, numberCeiling;

private:
	// Disallow the copy constructor and copy assignment
	AlDictionary (const AlDictionaryIterator &);
	AlDictionary &operator= (const AlDictionaryIterator &);
};

#endif // _AlDictionary
