/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//+
//	.NAME AlDeviationLocator - Interface to Alias deviation locator.
//
//	.SECTION Description
//		A deviation locator finds and displays the shortest distance between
//		two curves, from a given point on the first curve to the second curve.
//		The two curves can be any of the AlCurve or AlCurveOnSurface. This
//		class contains methods to create the locator, query the minimum distance,
//		and set the display attributes in the Alias windows. If any	two curves on
//		which this locator depends is deleted, this locator is automatically deleted.

#ifndef __AlDeviationLocator
#define __AlDeviationLocator


#include <AlLocator.h>

class STUDIOAPI_DECL AlDeviationLocator : public AlLocator
{
	friend class			AlFriend;

public:

	AlDeviationLocator();
	~AlDeviationLocator();
	virtual AlObject *	    copyWrapper() const;
	virtual AlObjectType	type() const;
	statusCode		        create(const AlCurve *, const AlCurve *, double baseParameter = 0.0);
	statusCode		        create(const AlCurveOnSurface *, const AlCurve *, double baseParameter = 0.0);
	statusCode		        create(const AlCurveOnSurface *, const AlCurveOnSurface *, double baseParameter = 0.0);
	statusCode              deviation(double &) const;
	statusCode              deviationComponents(double &, double &, double &) const;
	statusCode              setParameter(double);
	statusCode              parameter(double &) const;
	statusCode              parameterTargetCurve(double &) const;
	statusCode              setOffset(double, double, double);
	statusCode              offset(double &, double &, double &) const;
	statusCode              setLength(double);
	statusCode              length(double &) const;
	statusCode              setLeftJustify(API_BOOLEAN);
	statusCode              leftJustify(API_BOOLEAN &) const;
	
	statusCode				attachedTo( AlObject *&, AlObject *& );

};

#endif


