/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//	.NAME AlCurvePoint - Interface to Alias curve points.
//
//	.SECTION Description
//		A point can be created in the parametric space of any AlCurve. This
//		point can be queried for the curve normals, tangent, position in
//		world coordinate system, arc length, and curvature information. This
//		class contains methods for creating, and moving the curve point.
//
//		If the AlCurve is deleted, the curve point created on it is
//		automatically deleted.

#ifndef __AlCurvePoint
#define __AlCurvePoint

#include <AlPoint.h>

class AlCurveNode;

class STUDIOAPI_DECL AlCurvePoint : public AlPoint
{
	friend class			AlFriend;

public:

	AlCurvePoint();
	~AlCurvePoint();
	virtual AlObject *	    copyWrapper() const;
	virtual AlObjectType	type() const;
	statusCode		    	create(const AlCurve *, double);
	
	statusCode		    	setParameter(double);
	statusCode		    	parameter(double &) const;
	
	virtual statusCode		worldPosition(double &, double &, double &) const;
	
	statusCode          	tangent(double &, double &, double &) const;
	
	statusCode          	normal1(double &, double &, double &) const;
	
	statusCode          	normal2(double &, double &, double &) const;
	
	statusCode          	radius(double &) const;
	
	statusCode          	arcLength(double &) const;
	
	AlCurveNode	*			attachedTo();
};

#endif
