/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//	.NAME AlCurveOnSurfacePoint - Interface to Alias curve on surface points
//
//	.SECTION Description
//		A point can be created in the parametric space of a AlCurveOnSurface.
//		This point can be queried for the curve normals, tangent, and position
//		in world coordinate system. This class contains methods for creating,
//		and moving the point in the parametric space of the curve on surface.
//
//		If the AlCurveOnSurface or its AlSurface is deleted, the curve on
//		surface point created on it is automatically deleted.

#ifndef __AlCurveOnSurfacePoint
#define __AlCurveOnSurfacePoint

#include <AlPoint.h>

class AlCurveOnSurface;

class STUDIOAPI_DECL AlCurveOnSurfacePoint : public AlPoint
{
	friend class			AlFriend;

public:

	AlCurveOnSurfacePoint();
	~AlCurveOnSurfacePoint();
	virtual AlObject *		copyWrapper() const;
	virtual AlObjectType    type() const;
	statusCode		    	create(const AlCurveOnSurface *, double);
	
	statusCode		    	setParameter(double);
	
	statusCode		    	parameter(double &) const;
	
	virtual statusCode		worldPosition(double &, double &, double &) const;
	
	statusCode          	tangent(double &, double &, double &) const;
	
	statusCode          	normal1(double &, double &, double &) const;
	
	statusCode          	normal2(double &, double &, double &) const;
	
	statusCode          	arcLength(double &) const;
	
	AlCurveOnSurface *		attachedTo();
};

#endif
