/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlCurveOnSurface
#define _AlCurveOnSurface

//	.NAME AlCurveOnSurface - Interface to curves on surfaces geometry.
//
//	.SECTION Description
//		AlCurveOnSurface is the interface to Alias' curve on surface
//		data objects.  Curves on surfaces are created and added to a surface
//		by allocating an AlCurveOnSurface, then calling the
//		create() method, and then calling AlSurfaceNode's
//		addCurveOnSurface() method to add it to a surface.
//
//		Curves on surfaces can also be read in from wire file and modified
//		with this class.  Curves on surfaces will be deleted when the
//		surface they are attached to is deleted.
//
//		When constructing a curve on surface, you will notice that you
//		need to specify a matrix that has dimensions [numberOfControlPoints][4].
//		Each point has 4 values, for u, v, zero and w.  The "u" and "v"
//		specify the point in U-V parametric space.  The third component is zero
//		because this component is not used.  The "w" component is the
//		homogeneous value, which is usually 1.0.
//	.br
//		See the example programs for an example.
//

#include <AlObject.h>
#include <AlModel.h>
#include <AlPickable.h>

class AlTM;
class AlSurfaceNode;
class AlPersistentID;

class STUDIOAPI_DECL AlCurveOnSurface : public AlObject , public AlPickable 
{

	friend class			AlFriend;

public:
							AlCurveOnSurface();
	virtual					~AlCurveOnSurface();
	virtual statusCode		deleteObject();
	virtual AlObject*		copyWrapper() const;

	virtual AlObjectType	type() const;

	statusCode				create( int, curveFormType, int, const double[], int, const double[][4] );
	statusCode				create( int, const AlCurve*[] );

	statusCode				curveOnSurfaceData( double[], double[][4] ) const;
	statusCode				realCurveOnSurfaceData( double[], double[][4] ) const;

	int						degree() const;
	curveFormType			form() const;
	int						numberOfSpans() const;
	int						numberOfKnots() const;
	int						numberOfControlPoints() const;
	int 	   	  			realNumberOfKnots() const;

	double					knotValue( int ) const;
	statusCode				controlPoint( int, double[4] ) const;

	statusCode				setKnotValue( int, double );
	statusCode				setControlPoint( int, const double[4] );

	API_BOOLEAN					inTrim() const;
	API_BOOLEAN					visible() const;
	statusCode				setVisible( API_BOOLEAN ) const;

	statusCode				insert( double );
	statusCode 				reverse();

	AlSurface*				surface() const;

	statusCode				worldSpace3DCopies( int&, AlCurve **& );
	statusCode				unaffected3DCopies( int&, AlCurve **& );
	statusCode				affected3DCopies( AlTM&, int&, AlCurve **& );

	AlCurveOnSurface*		nextCurveOnSurface() const;
	AlCurveOnSurface*		prevCurveOnSurface() const;

	statusCode				nextCurveOnSurfaceD();
	statusCode				prevCurveOnSurfaceD();

	statusCode				persistentID( AlPersistentID *&id, int ut = 1 );
	statusCode				hasPersistentID( int ut = 1 );
	statusCode				setPersistentID( AlPersistentID &, int );
	
    statusCode 				blindData( int, long &, const char *& );
    statusCode 				setBlindData( int, long, const char * );
	statusCode				removeBlindData( int );
	
private:
	virtual API_BOOLEAN			extractType( int&, void*&, void*& ) const;

	static void				initMessages();
	static void				finiMessages();
};

#endif

