/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlCurveNode
#define _AlCurveNode

//
//	.NAME AlCurveNode - A dag node that refers to a nurbs curve's geometry.
//
//	.SECTION Description
//		AlCurveNode is the class used to access and manipulate
//		curves within the dag.
//		This class behaves like other dag nodes (see AlDagNode for a
//		description of the usage and purpose of dag nodes).
//		Users access the geometry of the curve
//		via the 'curve()' method which returns a
//		pointer to an AlCurve object which provides the user with
//		the methods used to modify the geometry of the curve.
//		Curves can be created from scratch by instantiating and creating
//		an AlCurve, and then by instantiating and creating an AlCurveNode
//		(using the AlCurve as a parameter).
//
//		There are two ways to delete an AlCurveNode.  If the AlCurveNode
//		deleteObject() method is called, then the node's AlCurve is also
//		deleted.  If the AlCurve::deleteObject() method is called, then its
//		associated AlCurveNode is also deleted.
//


typedef enum {	kJoinSuccess, kJoinFailure, kJoinBadCluster,
				kJoinInvalidKeyPoints, kJoinNoAttributes, kJoinBadData,
				kJoinDuplicateCurve, kJoinCurveClosed
			} AlCurveNodeJoinErrors;

#include <AlDagNode.h>
#include <AlModel.h>

class STUDIOAPI_DECL AlCurveNode : public AlDagNode 
{
	friend					class AlFriend;
public:
							AlCurveNode();
	virtual					~AlCurveNode();
	virtual AlObject*		copyWrapper() const;

	statusCode				create( AlCurve* );

	virtual AlObjectType	type() const;

	AlCurve*				curve() const;
	AlCurve*				curve(AlTM&) const;

	AlCurveNodeJoinErrors	join(AlCurveNode*);

protected:
};

#endif	/* _AlCurveNode */
