/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlCurveAttributes
#define _AlCurveAttributes

//
//	.NAME AlCurveAttributes - Interface to Alias curve attributes.
//
//	.SECTION Description
//
//		AlCurveAttributes is a class derived from the AlAttributes class.
//		This class allows access to a curve.
//
//		This class provides information similar to that of the AlCurve
//		class but without the ability to modify the curve or its CVs.
//
//		NOTE: When an AlCurve has just an AlCurveAttribute attribute
//		the AlCurveAttribute provides no information that the AlCurve
//		doesn't. For this reason, in this case, no information is
//		provided by the AlCurveAttribute, all methods return null
//		values.
//

#include <AlAttributes.h>
#include <AlModel.h>

class STUDIOAPI_DECL AlCurveAttributes : public AlAttributes 
{
	friend class AlFriend;

public:
	virtual AlObjectType			type() const;
	AlObject*						copyWrapper() const;

	curveFormType			form() const;
	int						degree() const;
	int						numberOfSpans() const;
	int						numberOfCVs() const;
	statusCode				CVsUnaffectedPosition( double[][4], int[] ) const;
	int						numberOfKnots() const;
	statusCode				knotVector( double[] ) const;

protected:
							AlCurveAttributes( struct Spline_surface* );
	virtual					~AlCurveAttributes();

private:
	API_BOOLEAN					isPeriodic() const;
	API_BOOLEAN					isClosed() const;
	struct ag_cnode*		firstCV() const;
	struct ag_cnode*		nextCV( struct ag_cnode* ) const;
	statusCode				unaffectedPosition( struct ag_cnode*, double&, double&, double&, double& ) const;
	int						multiplicity(struct ag_cnode*) const;
};
#endif
