/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlCursor - Interface to Alias cursors
//
//	.SECTION Description
//		This class allows you to display predefined cursors inside of OpenAlias.
//		Cursors are maintained using a stack of ID numbers.  When a cursor
//		image is set, its ID is pushed onto the stack.  When a cursor is popped,
//		its image is restored to the previous image.
//

#ifndef _AlCursor_h
#define _AlCursor_h

#include <AlStyle.h>

class STUDIOAPI_DECL  AlCursor
{
public:
	enum {	kArrowSquare=0, kEmpty, kHourGlass, kEyeDropper, kFullEyeDropper,
			kMove, kSelect, kInsert, kDelete, kCross, kTarget } Predefined;

	static statusCode	push( int id );
	static statusCode	pop( void );
};

#endif
