/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlCommandRef - Interface to construction history command constructors, AlContact - Interface to Alias contact information.
//
//	.SECTION Description
//		Two classes are defined here.  The first AlContact is used to access
//		Alias contact information.  It can be used in conjunction with commands
//		to describe a constructor curve.
//		The second class AlCommandRef is used to access the constructor
//		references for the command.
//

#ifndef _AlContact
#define _AlContact

#include <AlObject.h>

class STUDIOAPI_DECL  AlCommandRef : public AlObject
{
	friend class			AlFriend;
	friend class			AlCommandFriend;
public:
							AlCommandRef();
	virtual					~AlCommandRef();
	virtual AlObjectType	type() const;

	AlCommandRef*			nextRef();
	AlCommandRef*			prevRef();
	statusCode				nextRefD();
	statusCode				prevRefD();

	AlDagNode*				dagNode();
	AlCurveOnSurface*		curveOnSurface();
	AlContact*				contact();

private:
	static void             initMessages();
	static void             finiMessages();
};

enum AlContactType	{	kContactInvalid, kContactIsoparamU, kContactIsoparamV,
						kContactCurveOnSurface, kContactTrimEdge,
						kContactFreeCurve };

class STUDIOAPI_DECL AlContact : public AlObject
{
	friend class			AlFriend;
	friend class			AlCommandFriend;

public:
							AlContact();
	virtual					~AlContact();

	statusCode				deleteObject();
	virtual AlObjectType	type() const;

	statusCode				create();

	statusCode				appendContact( AlContact * );
	int						numberContacts() const;
	AlContact*				nextContact();
	AlContact*				prevContact();
	statusCode				nextContactD();
	statusCode				prevContactD();

	AlContactType			contactType() const;

	// These are different values common to the various contact types
	// derived classes are not used since this would result in about 6
	// new classes, each with a single method.
	// These could be added later
	//
	statusCode			calculate( AlDagNode *dagNode, double tolerance = 0, API_BOOLEAN adjustTolerance = FALSE );
	API_BOOLEAN				areEqual( AlDagNode *dagNodeThis, AlContact *contactOther, AlDagNode *dagNodeOther) const;


	AlTrimCurve*			trimCurve();
	AlCurveOnSurface*		curveOnSurface();
	int						freeCurveIndex();
	double					curveOnSurfaceParam() const;
	double					paramValue() const;
	double					nonisoparamMin() const;
	double					nonisoparamMax() const;

	AlCurve*				curve();
	AlCurve*				curveUV();

private:
	static void             initMessages();
	static void             finiMessages();
};

#endif	// _AlContact

