/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//	.NAME AlConstructionVector	-  Interface to Alias construction vectors.
//
//	.SECTION Description
//		Alias construction vectors can be created with 2 points or with 1 point
//		and a vector.  The origin and end points of this object can be queried
//		through the use of this class.  If a construction vector is created with
//		1 point and a vector, the end point will be NULL.  In addition, if a 
//		construction vector is created with 2 points, the vector cannot be 
//		queried or set.
//
//

#ifndef _AlConstructionVector
#define  _AlConstructionVector

#include <AlConstructionEntity.h>

class AlPoint;

class STUDIOAPI_DECL  AlConstructionVector :	public AlConstructionEntity
{
	friend class			AlFriend;
public:
							AlConstructionVector();
	virtual					~AlConstructionVector();

	virtual AlObject*		copyWrapper() const;
	virtual AlObjectType	type() const;

	statusCode				create( AlPoint *,double, double, double );
	statusCode				create( AlPoint *, AlPoint * );
	
	statusCode				vector( double&, double&, double& );
	statusCode				setVector( double, double, double );
	
	AlPoint*				origin();
	AlPoint*				end();

};

#endif // _AlConstructionVector
