/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//	.NAME AlConstructionPlane	-  Interface to Alias construction planes.
//
//	.SECTION Description
//		This class provides functionality for creating, manipulating and
//		querying Alias construction planes.  Construction planes can be 
//		specified several ways.  
//		
//			3 Points - The first 2 points specify the X axis. The first and last points 
//		specifiy a line that is used in the cross product with the x axis to
//		provide the Z axis.  Once the Z is known, the Y axis is calculated 
//		internally.
//
//			2 points and a normal - The first 2 points specify the X axis.  The normal
//		is the Z axis to the plane.
//
//		This class provides access to the points used to create the construction
//		plane( end may be NULL depending on the specification), transformation
//		and axes information.
//
//

#ifndef _AlConstructionPlane
#define  _AlConstructionPlane

#include <AlConstructionEntity.h>

class AlPoint;

class STUDIOAPI_DECL AlConstructionPlane :	public AlConstructionEntity
{
	friend class			AlFriend;
public:
							AlConstructionPlane();
	virtual					~AlConstructionPlane();

	virtual AlObject*		copyWrapper() const;
	virtual AlObjectType	type() const;

	statusCode				create( AlPoint *, AlPoint *, AlPoint * );
	statusCode				create( AlPoint *, AlPoint *, double[3] );
	statusCode				create(double[3], double[3], double[3]) ;
	
	AlPoint *				first();
	AlPoint *				second();
	AlPoint *				third();
	
	statusCode				scale( double&, double& );
	statusCode				setScale( double, double );
	
	statusCode				rotate( double&, double&, double& );
	statusCode 				translate( double&, double&, double& );
	
	statusCode				transformationMatrix( double[4][4] );
	statusCode				origin( double&, double&, double& );
	statusCode				axes( double[3], double[3], double[3] );
	
	statusCode 				normal( double &, double &, double & );
	statusCode				equation( double &, double &, double &, double & );

};

#endif // _AlConstructionPlane
