/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//	.NAME AlConstructionEntity - base class for Alias construction entities.
//
//	.SECTION Description
//		This base class encapsulates methods common to Alias construction entities.  These
//		entities include space points, curve points, surface points, curve on surface points,
//		construction planes and construction vectors.
//		Construction points have similiarities to locator objects.  A major difference
//		between construction points and locators is that construction points will be on
//		the Alias pick list.  The AlPickList class can be used to retrieve picked 
//		construction entity objects.  As you will see below, the AlConstructionEntity
//		class multiply inherits from the AlPickable class.
//	
//		This class contains methods for deleting, and naming locators.
//		In addition, methods are available for working with layers and for changing
//		invisibility and templated modes.
//
//		As in the locator objects, if a construction entity is dependent on an object
//		that is deleted, it will also be removed.
//
//		The construction entity hierarchy is the following:
//
// .ss 24
//	.nf
//	%@	   					            AlConstructionEntity
//	%@	                 					|
//	%@	  				_____________________________________________
//	%@	  				|					|						|			
//	%@	  			AlPoint		AlConstructionVector	AlConstructionPlane
//	%@					|
//	%@		____________________________
//	%@		|		|		|			|
//	%@	Space	Curve 	Surface		Curve On Surface
//	%@
//	.fi
// .ss 12
//
//	The AlPoint class cannot be instantiated.

#ifndef __AlConstructionEntity
#define __AlConstructionEntity

#include <AlObject.h>
#include <AlPickable.h>

class STUDIOAPI_DECL  AlConstructionEntity : public AlObject, public AlPickable 
{
	friend                  class AlFriend;

public:
	virtual ~AlConstructionEntity();
	virtual statusCode	    deleteObject();
	virtual AlObject *	    copyWrapper() const = 0;
	virtual AlObjectType	type() const;

	virtual const char*		name() const;
	virtual statusCode		setName( const char * );
		
	AlLayer *				layer();
	statusCode 				setLayer( AlLayer * );

	API_BOOLEAN					invisible();
	statusCode				setInvisible( API_BOOLEAN );

	statusCode              templated(API_BOOLEAN &) const;

protected:
	AlConstructionEntity();
private:
	virtual API_BOOLEAN 			extractType( int&, void*&, void*& ) const;
	static void		       initMessages();
	static void		       finiMessages();
};
#endif






























