/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlConstraint
#define _AlConstraint

//
//	.NAME AlConstraint - Interface to IK constraint data.
//
//	.SECTION Description
//		The AlConstraint class allows access to the IK constraint information
//		on an AlJoint.
//
//		(See the discussion of skeletons, joints, contraints, ik, etc. in
//		the Alias Studio manuals for a full description.)
//
//		Briefly, the constraint data constrains the joint node to another
//		object. The constraint can be a point constraint, an orientation
//		constraint, or an aim constraint.
//
//		This is the base class for constraints. Point, orientation, and
//		aim constraints are derived from this class.
//

#include <AlObject.h>
#include <AlAnimatable.h>

extern "C" {
	struct Ik_constraint_data_s;
}

class AlDagNode;
struct Dag_node;

class STUDIOAPI_DECL  AlConstraint : public AlObject , public AlAnimatable
{
	friend class			AlFriend;

public:
	virtual 				~AlConstraint();

	virtual statusCode		deleteObject();

	virtual AlObjectType	type() const;

	AlConstraint*			next( void ) const;

	API_BOOLEAN					on() const;
	double					weight() const;
	API_BOOLEAN					isUVConstraint() const;
	statusCode				uv( double[2] ) const;

	statusCode				setOn( API_BOOLEAN );
	statusCode				setWeight( double );
	statusCode				setUV( double[2] );

	AlDagNode*				sourceNode( void ) const;
	AlDagNode*				destinationNode( void ) const;

protected:
							AlConstraint();

	statusCode				makeAConstraint( AlDagNode*, AlDagNode*, int,
								int, int );
	statusCode				makeAConstraint( AlDagNode*, AlDagNode*, int,
								int, int, double[2] );

	void					constraint_modified( void );

private:
	virtual API_BOOLEAN			extractType( int&, void*&, void*& ) const;

	static void initMessages();
	static void finiMessages();
};

#endif	/* _AlConstraint */
