/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlConicAttributes
#define _AlConicAttributes

//	.NAME AlConicAttributes - Interface to Alias conic curve attributes.
//
//	.SECTION Description
//
//		AlConicAttributes is a class derived from the AlAttributes class.
//		This class allows access to the attributes for a conic section.
//
//		Conics may not be created. They may be brought into Alias
//		through the IGES interface though.
//
//		A conic is one of ellipse, hyperbola, parabola, circle, or
//		line. Conics exist in the XY plane and are defined by the
//		equation: A * X^2 + B * X * Y + C * Y^2 + D * X + E * Y + F = 0.
//


typedef enum { kNoConic = 0, kEllipse = 1, kHyperbola = 2, kParabola = 3, kCircle = 4, kLine = 5 } AlConicType;

#include <AlAttributes.h>
class AlTM;

class STUDIOAPI_DECL  AlConicAttributes : public AlAttributes 
{
	friend class					AlFriend;

public:
	virtual AlObjectType			type() const;
	AlObject*						copyWrapper() const;

	statusCode				coefficients( double&, double&, double&, double&, double&, double& ) const;
	double					zDisplacement() const;
	statusCode				startPoint( double&, double& ) const;
	statusCode				endPoint( double&, double& ) const;
	statusCode				centerPoint( double&, double& ) const;
	statusCode				transform( double[4][4] ) const;
	statusCode				transform( AlTM& ) const;
	AlConicType				form() const;

protected:
							AlConicAttributes(struct Spline_surface*);
	virtual					~AlConicAttributes();
};

#endif	/* _AlConicAttributes */
