/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlConeLight - Adds parameters for Cone shaped Volume Lights
//
//	.SECTION Description
//
//		A cone light allows light to exist inside the volume of a cone.
//
//		A cone light could be made similar to a spotlight by setting
//		Concentric and radial to 0, directional to 1, decay to 0
//		and dropoff to slightly less than 1.
//
//		A cone light would make a good vortex field by setting the
//		Radial to 1, concentric to .5, directional depending on whether
//		the vortex is sucking up things or dropping them.
//


#ifndef _AlConeLight
#define _AlConeLight

#include <AlVolumeLight.h>

class STUDIOAPI_DECL  AlConeLight: public AlVolumeLight{

public:
						AlConeLight();
	virtual				~AlConeLight();

	virtual AlObject*	copyWrapper() const;

	statusCode          create();

	virtual AlObjectType	type() const;

	double 				arc() const;
	double 				coneEndRadius() const;

	statusCode			setArc(double);
	statusCode			setConeEndRadius(double);

private:
	// init/fini inherited
};
#endif
