/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlClusterable - Encapsulates methods common to Alias objects which can belong to clusters.
//
//	.SECTION Description
//
//		This class is a base class for all objects which can be
//		contained in a cluster. It provides the methods necessary
//		to access the cluster methods of these objects.
//

#ifndef _AlClusterable
#define _AlClusterable

#include <AlObject.h>

class AlIterator;

//-
//	Note that this class relies on the fact the classes derived from it
//	overload the extractType function in AlObject.  In theory, we should be
//	introducing a new base class, AlTypeable, which has a pure virtual
//	extractType method.  But this introduces a lot of extra code.  Let's just
//	assume for now that if AlFoo inherits AlClusterable, then AlFoo provides
//	a working extractType method.
//+

class AlCluster;
class AlClusterMember;

class STUDIOAPI_DECL AlClusterable 
{
	friend class		AlFriend;
public:

	AlCluster*			firstCluster() const;

	AlCluster*			nextCluster( const AlCluster* ) const;
	AlCluster*			prevCluster( const AlCluster* ) const;

	statusCode			nextClusterD( AlCluster* ) const;
	statusCode			prevClusterD( AlCluster* ) const;

	statusCode			applyIteratorToClusters( AlIterator*, int& );

	statusCode          addToCluster( AlCluster*, double = 1.0 );
	statusCode          removeFromCluster( AlCluster* );
	statusCode			removeFromAllClusters();
	AlClusterMember*    isClusterMember( AlCluster* ) const;
	double              percentEffect( AlCluster* ) const;
	statusCode          setPercentEffect( AlCluster*, double );

protected:
						AlClusterable();
	virtual				~AlClusterable();

	virtual API_BOOLEAN		extractType( int&, void *&, void *& ) const;
};
#endif
