/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlClusterPreTMItem - An item of a list holding AlTMs and AlCluster.
//
//	.SECTION Description
//		This class is used in a list of objects(AlList) created by
//		the AlDagNode::clusterPreTransformationMatrices() method.
//		It is derived from AlLinkItem.
//

#ifndef _AlClusterPreTMItem
#define _AlClusterPreTMItem

#include <AlLinkItem.h>
#include <AlTM.h>

struct	Cl_Pre_tm;
class	AlCluster;
class	AlFriend;

class STUDIOAPI_DECL  AlClusterPreTMItem : public AlLinkItem
{
		friend class	AlDagNode;
		friend class	AlFriend;

	public:
		~AlClusterPreTMItem();
		AlClusterPreTMItem*	nextItem() { return (AlClusterPreTMItem*) next(); }
		AlClusterPreTMItem*	prevItem() { return (AlClusterPreTMItem*) prev(); }

		AlTM		fTM;
		AlTM		fInvTM;
		AlCluster*	fAlCluster;

	protected:
		AlClusterPreTMItem( Cl_Pre_tm* );

};

#endif
