/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlClusterNode - is the dag node class for clusters.
//
//	.SECTION Description
//
//
//		This class is a dag node class used specifically for clusters.
//		Every AlClusterNode object has an AlCluster attached to it.
//		(For more information on how AlCluster's and AlClusterNode's
//		work together, see the Class Description for the AlCluster object.)
//
//		To create a cluster node, the user must instantiate and call
//		the create method on an AlCluster object, which will automatically
//		create an AlClusterNode.  The user cannot directly instantiate
//		an AlClusterNode.
//
//		A cluster node can be deleted in two ways.  When a cluster node
//		is deleted, its associated cluster is deleted.  When a
//		cluster is deleted, its cluster node is also deleted.
//

#ifndef _AlClusterNode
#define _AlClusterNode

#include <AlDagNode.h>

class STUDIOAPI_DECL  AlClusterNode : public AlDagNode 
{
	friend class			AlFriend;
public:

	virtual					~AlClusterNode();
	virtual AlObject*		copyWrapper() const;

	virtual AlObjectType	type() const;

	virtual API_BOOLEAN			isInstanceable();

	AlCluster				*cluster() const;
	AlCluster				*cluster(AlTM&) const;

protected:
	// AlClusterNode is a virtual class.  It
	// can only be instantiated by an AlCluster
	// object.
	//
							AlClusterNode();
};

#endif
