/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlCategory - Interface to Alias category objects.
//
//	.SECTION Description
//      Categories are a way of organizing lists of layers.
//      This organization simplifies changing the attributes 
//      of associated layers. 
//
//      Each AlCategory has a non unique name, picked status, description
//      and a list of associated layers. 
//
//      The layer list contains layer numbers
//
//      Notes
//
//      1) Attempting to add a layer to a category that is already 
//         in the list will fail.
//
//      2) Layers can belong to multiple categories.
//
//      3) All functions will fail if layers are not enabled.
//
//      4) AlCategory is available through OpenModel
//


#ifndef _AlCategory
#define _AlCategory

#include <AlObject.h>


class AlFriend;

class STUDIOAPI_DECL  AlCategory : public AlObject{
	friend					class AlFriend;
public:

	virtual					~AlCategory();	
							AlCategory();	
	
	virtual AlObject*		copyWrapper() const;
	virtual statusCode		deleteObject();
	virtual AlObjectType	type() const;

	statusCode				create(const char * = NULL);

	statusCode				addMember(int);
    statusCode              removeMember(int);
    int                     numberOfMembers() const;
    statusCode              members(int numMembers, int members[]);

	const char *			name() const;
	statusCode			    setName( const char*);

	const char *			description() const;
	statusCode			    setDescription( const char*);

    statusCode              pick(API_BOOLEAN);
    API_BOOLEAN                     isPicked() const;

protected:
	
private:
	static void				initMessages();
	static void				finiMessages();
};

#endif // _AlCategory









