/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlCameraNode - Dag node class for cameras.
//
//	.SECTION Description
//
//		This class is a dag node class used specifically for cameras.
//		Each AlCamera object has three camera nodes. One for each of eye,
//		view and
//		up positions.  (For more information on how AlCamera's and
//		AlCameraNode's work together, see the Class Description for
//		the AlCamera object.)
//
//		To create a camera node, the user must create a camera,
//		which will automatically create the necessary camera nodes.
//		The user cannot directly instantiate an AlCameraNode.
//
//		To figure out which position a camera node represents, the
//		user can use:
// .br
//			1) the isEyeNode(), isViewNode(), isUpNode() methods, or
// .br
//			2) the type() method to compare types with kCameraEyeType,
//				kCameraUpType, or kCameraViewType.
//
//		A camera node can be deleted in two ways.  When a camera node
//		is deleted, its associated camera (and other camera nodes)
//		are deleted.  When a camera is deleted, its camera nodes
//		are also deleted.
//

#ifndef _AlCameraNode
#define _AlCameraNode

#include <AlDagNode.h>

class AlCamera;

extern "C" {
	struct Dag_node;
}

class STUDIOAPI_DECL AlCameraNode : public AlDagNode {
	friend class AlFriend;
	friend class AlCamera;

public:
	virtual					~AlCameraNode();
	virtual AlObject*		copyWrapper() const;
	virtual statusCode		deleteObject();

	virtual AlObjectType	type() const;
	virtual API_BOOLEAN			isInstanceable();

	API_BOOLEAN				isEyeNode() const;
	API_BOOLEAN				isViewNode() const;
	API_BOOLEAN				isUpNode() const;

	AlCamera*			camera() const;
	AlCamera*			camera(AlTM&) const;

private:
	AlCameraNode( AlObjectType thisType, Dag_node *node );

	//	Store the object type
	//
	AlObjectType		fType;
};
#endif
