/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//	.NAME AlCamera - A base class that encapsulates behavior of perspective
//		  and orthographic cameras.
//
//	.SECTION Description
//		This class used to represent all the functionality of Alias perspective
//		cameras.  When the AlWindow class was born and it became possible to
//		get and set the window associated with a camera, it became necessary
//		not only to provide an interface to orthographic cameras as well, but
//		also to separate the differences in functionality into two child
//		classes.  The AlCamera class remains as a base class, providing access
//		to the behavior that all cameras share.  In places where AlCameras
//		were formerly used, it is possible to easily convert old code simply
//		by substituting AlPerspectiveCamera for AlCamera almost everywhere.
//		(A few other small modifications may be necessary).
//
//		Any camera can have image planes attached to it.  To create an image
//		plane on a camera, use the addImagePlane command.
//
//		If a window is associated with this camera (which will always be the
//		case for orthographic cameras, but not so for perspective cameras)
//		the firstWindow() function will return it.
//

#ifndef _AlCamera
#define _AlCamera

#include <AlObject.h>

class AlIterator;
class AlWindow;
class AlImagePlane;
class AlCameraNode;
class AlDagNode;
struct Dag_node;

class STUDIOAPI_DECL AlCamera	: public AlObject
{

	friend class			AlFriend;
public:
	virtual					~AlCamera();

	virtual statusCode		deleteObject();
	virtual AlObject*  		copyWrapper() const;

	virtual AlObjectType	type() const;

	virtual const char*		name() const;
	virtual statusCode		setName( const char* );

	statusCode				addImagePlane( const char * );
	AlImagePlane*			firstImagePlane( void );
	statusCode				applyIteratorToImagePlanes( AlIterator*, int& );

	AlWindow*				firstWindow( void );
	AlWindow*				nextWindow( AlWindow *lastWindow );
	statusCode				nextWindowD( AlWindow *lastWindow );

	statusCode				nearClippingPlane( double& ) const;
	statusCode				farClippingPlane( double& ) const;

	statusCode				setNearClippingPlane( double );
	statusCode				setFarClippingPlane( double );

	statusCode				stereoView(API_BOOLEAN&, double&) const;
	statusCode				setStereoView(API_BOOLEAN, double);

	statusCode				motionBlur(API_BOOLEAN&) const;
	statusCode				setMotionBlur(API_BOOLEAN);

protected:
							AlCamera();
private:
	static void				initMessages();
	static void				finiMessages();
};

#endif
