/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlBoxLight - A class used to reference a box light
//
//	.SECTION Description
//
//		A box light is a volume light where light exists within a cube.
//		There are no additional parameters other than those already on
//		the volume light.
//
//		A box light could be np-scaled and used to fill a room with light.
//		If it is used as a force field, it could fill the room with turbulence,
//		leaving the air outide the room still.
//


#ifndef _AlBoxLight
#define _AlBoxLight

#include <AlVolumeLight.h>

class STUDIOAPI_DECL AlBoxLight: public AlVolumeLight{

public:
						AlBoxLight();
	virtual				~AlBoxLight();
	statusCode			create();
	virtual AlObject*	copyWrapper() const;

	virtual AlObjectType	type() const;

private:
	// init/fini inherited
};
#endif
