/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//	.NAME AlBlindData - Improved blind data support class.
//
//	.SECTION Description
//		This class provides a base class for plug-ins and OpenModel
//		applications which need to maintain blind data (that is, data
//		which Studio does not know about). This class supersedes the
//		existing blind data support (AlDagNode::blindData for example).
//
//		The previous implementation for blind data did not provide any
//		support for moving data between platforms which have different
//		endian representations (for example Irix and NT). This class
//		provides a nearly invisible solution to this problem. As such
//		the previous implementation is obsolete and will be removed in
//		a future release of the API.
//
//		For a thorough example using this class please see the online
//		documentation.


#ifndef _AlBlindData
#define _AlBlindData

#include <AlStyle.h>

class AlObject;
class AlUniverse;

class STUDIOAPI_DECL AlBlindData
{
	public:
						AlBlindData(AlObject *obj, int userID, size_t size);
						AlBlindData(int userID, size_t size);
		virtual			~AlBlindData();
		virtual statusCode		create();
		virtual statusCode		deleteData();
		virtual bool			isValid() const;

	protected:
		void			convert(int&);
		void			convert(float&);
		void			convert(short&);
		void			convert(double&);

		void			setEndian();
		void			*getData() const;
		AlObject		*obj;
		bool			univ;

	private:
		void			*data;
		int				id;
		size_t			size;
};
#endif	// _AlBlindData
