/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//
//	.NAME AlBlendCurve - interface to Alias blend curves.
//
//	.SECTION Description
//
//		An Alias Blend Curve is a normal NURBS curve with contruction history.
//		This class allows blend curves to be created and intersected with other
//		curves, curves on surfaces, blend curves and surfaces.  Note that
//		intersection with clouds is not currently supported.
//		Blend Curves contain Blend Points so it is necessary to use the 
//		AlBlendPoint class to make use of all of the Blend Curve functionality.
//		To find the curve node which is the the output of the Blend Curve
//		command, use the curveNode() method.  
//
//		Notes:
//		1. If a blend curve is active and the API is used to
//		create another blend curve, the first blend curve will become inactive.
//		2. Blend curves can be made active or inactive by finding the
//		curveNode() method and calling pick() on unpick() with the
//		AlCurveNode.
//

#ifndef _AlBlendCurve
#define  _AlBlendCurve

#include <AlStyle.h>
#include <AlObject.h>

class AlCurveNode;
class AlBlendPoint;

class STUDIOAPI_DECL  AlBlendCurve :	public AlObject
{
	friend class			AlFriend;
public:

	enum AlKnotSpacingType
	{
		kChord,
		kUniform
	};

							AlBlendCurve();
	virtual					~AlBlendCurve();

	virtual statusCode		deleteObject();
	virtual AlObject*		copyWrapper() const;

	statusCode				create( int , AlKnotSpacingType , int , const double[][3] );
	statusCode				create( int , AlKnotSpacingType );
	virtual AlObjectType	type() const;

	int						degree();
	statusCode				setDegree( int );
	
	statusCode				knotSpacingType( AlKnotSpacingType& );
	statusCode				setKnotSpacingType( AlKnotSpacingType );

	int						numberOfPoints();
	
	statusCode 				param( int, double& );

	AlBlendPoint*			getPoint( int );
	statusCode				points( int, double[] );

	statusCode				insert( int, double, double, double );
	statusCode				append( double, double, double );
	
	API_BOOLEAN					isPicked();

	AlBlendCurve*			next();
	statusCode				nextD( AlBlendCurve * );
	AlBlendCurve*			prev();
	statusCode				prevD( AlBlendCurve * );

	AlCurveNode*			curveNode();

private:

	static void initMessages();
	static void finiMessages();
};

#endif // _AlBlendCurve
