/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlAttributes
#define _AlAttributes

//
//	.NAME AlAttributes - Interface to Alias curve and surface attributes.
//
//	.SECTION Description
//
//		AlAttributes is the base class for a set of classes which
//		allow access to curve and surface attributes. It is not
//		possible to create AlAttributes directly, instead they are
//		created when you use the AlCurve::create*() methods.
//
//		An attribute is an alternate way to specify an
//		object.  For example, in Alias normally a circle would be
//		represented by a NURBS curve which approximates a circle.
//		With attributes instead, a circle is represented by an
//		origin, a radius, etc.  Several types of attributes are
//		derived from this class which are used for particular
//		types of objects.
//

#include <AlObject.h>

class STUDIOAPI_DECL AlAttributes : public AlObject 
{
	friend class				AlFriend;

public:
	virtual						~AlAttributes();
	virtual AlObjectType		type() const;
	AlObject*					copyWrapper() const;

	AlAttributes*				nextAttribute() const;

protected:
								AlAttributes(struct Spline_surface*);
	Spline_surface*				fParent;

private:
	static void					initMessages();
	static void					finiMessages();
};

#endif
