/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
#ifndef _AlArcAttributes
#define _AlArcAttributes

//
//	.NAME AlArcAttributes - Interface to Alias arc curve attributes.
//
//	.SECTION Description
//
//		AlArcAttributes is a class derived from the AlAttributes class.
//		This class allows access to the attributes for an arc.
//
//		The attributes which define an arc are its radius, sweep
//		angle, center point, start point, and end point.
//		Coordinates are given in object space, and not world space.
//

#include <AlAttributes.h>

class STUDIOAPI_DECL AlArcAttributes : public AlAttributes 
{
	friend class			AlFriend;

public:
	virtual AlObjectType			type() const;
	AlObject*						copyWrapper() const;

	statusCode				centerPoint(double&, double&, double&) const;
	statusCode				startPoint(double&, double&, double&) const;
	statusCode				endPoint(double&, double&, double&) const;
	double					sweep() const;
	double					radius() const;
    statusCode              calculateStartAndEndAngles(
                                              double& start_angle,
                                              double& end_angle,
                                              double xaxis[3],
                                              double yaxis[3],
                                              double zaxis[3]);


	statusCode				setStartPoint(double, double, double);
	statusCode				setEndPoint(double, double, double);
	statusCode				setSweepFromStartPoint(double);
	statusCode				setSweepFromEndPoint(double);
	statusCode				setRadius(double);
protected:
							AlArcAttributes(struct Spline_surface*);
	virtual					~AlArcAttributes();
};

#endif
