/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/
//	.NAME AlAnnotationLocator - Displays a text string for existing locators
//
//	.SECTION Description
//		This class creates an annotation to the existing point locators such as a
//		space locator, curve locator, curve on surface locator, and surface locator.
//		An annotation is a line of text and a leader (line with arrow) that is drawn
//		relative to another locator (point type).
//
//		To use this locator, create any point locator and attach the annotation string
//		through this locator using the create method. There are also methods to
//		manipulate the position and starting point of the leader line for the annotation.

#ifndef __AlAnnotationLocator
#define __AlAnnotationLocator


#include <AlLocator.h>

class AlPoint;

class STUDIOAPI_DECL AlAnnotationLocator : public AlLocator
{
	friend class				AlFriend;

	public:
	AlAnnotationLocator();
	~AlAnnotationLocator();
	
	virtual AlObject *		copyWrapper() const;
	virtual AlObjectType	type() const;
	statusCode		   		create(double start_x, double start_y, double start_z, const char *, double end_x, double end_y, double end_z);
	
	statusCode		   		setString(const char *);
	const char *			string() const;

	statusCode				setWorldLeaderPosition(double x = 0.0, double y = 0.0, double z = 0.0);
	statusCode				worldLeaderPosition(double &, double &, double &) const;

	statusCode				setLocalLeaderPosition(double x = 0.0, double y = 0.0, double z = 0.0);
	statusCode				localLeaderPosition(double &, double &, double &) const;

	statusCode				setOffset( double x, double y, double z );
	statusCode				offset( double &x, double &y, double &z ) const;

	statusCode				setLength( double length );
	statusCode				length( double &length ) const;

	statusCode				setShowArrow( API_BOOLEAN showArrow);
	statusCode				showArrow( API_BOOLEAN &showArrow ) const;

	statusCode              setLeftJustify(API_BOOLEAN);
	statusCode              leftJustify(API_BOOLEAN &) const;

	statusCode				point( double &x, double &y, double &z ) const;
};


#endif


