/********************************************************************
 * (C) Copyright 2006 by Autodesk, Inc. All Rights Reserved. By using
 * this code,  you  are  agreeing  to the terms and conditions of the
 * License  Agreement  included  in  the documentation for this code.
 * AUTODESK  MAKES  NO  WARRANTIES,  EXPRESS  OR  IMPLIED,  AS TO THE
 * CORRECTNESS OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE
 * IT.  AUTODESK PROVIDES THE CODE ON AN 'AS-IS' BASIS AND EXPLICITLY
 * DISCLAIMS  ANY  LIABILITY,  INCLUDING CONSEQUENTIAL AND INCIDENTAL
 * DAMAGES  FOR ERRORS, OMISSIONS, AND  OTHER  PROBLEMS IN THE  CODE.
 *
 * Use, duplication,  or disclosure by the U.S. Government is subject
 * to  restrictions  set forth  in FAR 52.227-19 (Commercial Computer
 * Software Restricted Rights) as well as DFAR 252.227-7013(c)(1)(ii)
 * (Rights  in Technical Data and Computer Software),  as applicable.
 *******************************************************************/

//
//	.NAME AlAnimatable - Basic Interface to Alias objects which support animation.
//
//	.SECTION Description
//		This class encapsulates the functionality of Alias objects
//		which have the capacity to be animated.  It provides access
//		to channels.
//

#ifndef _AlAnimatable
#define _AlAnimatable

class AlIterator;
class AlList;
struct AI_Parm_ctrl;

class STUDIOAPI_DECL AlAnimatable
{
	friend			class AlFriend;

public:
	AlChannel*				firstChannel() const;

	AlChannel*				nextChannel( const AlChannel* ) const;
	AlChannel*				prevChannel( const AlChannel* ) const;

	statusCode				nextChannelD( AlChannel* ) const;
	statusCode				prevChannelD( AlChannel* ) const;

	statusCode				applyIteratorToChannels( AlIterator*, int &);

	statusCode				deleteAnimation();

	AlChannel*				findChannel( int ) const;
	double 					sampleChannel( int ) const;

	statusCode				globalParam( const char *param, API_BOOLEAN& );
	AlList*					globalParamList();

	statusCode				localParam( const char *param, API_BOOLEAN& );
	AlList*					localParamList();

	statusCode				setLocalParam( const char *paramName, API_BOOLEAN state );
	statusCode				setGlobalParam( const char *paramName, API_BOOLEAN state );

protected:
							AlAnimatable();
	virtual 				~AlAnimatable();

	virtual API_BOOLEAN			extractType( int&, void *&, void *& ) const;

private:
	static AlList*			buildParamList( AI_Parm_ctrl* );
};

//-
class STUDIOAPI_DECL AlParamItem : public AlLinkItem
{
	friend class	AlAnimatable;

public:
	AlParamItem*	nextItem() { return (AlParamItem *) next(); }
	AlParamItem*	prevItem() { return (AlParamItem *) prev(); }

	char*			name;
	API_BOOLEAN			value;

protected:
					AlParamItem( const char*, API_BOOLEAN);
	virtual			~AlParamItem();
};
//+

#endif // _AlAnimatable
